VERSION 5.00
Begin VB.Form ReportForm 
   Caption         =   "Report"
   ClientHeight    =   9540
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   11460
   LinkTopic       =   "Form1"
   ScaleHeight     =   9540
   ScaleWidth      =   11460
   StartUpPosition =   2  'CenterScreen
   Begin Project1.ArmPrint ArmPrint 
      Height          =   9435
      Left            =   60
      TabIndex        =   0
      Top             =   60
      Width           =   11355
      _ExtentX        =   20029
      _ExtentY        =   16642
   End
End
Attribute VB_Name = "ReportForm"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private mo_ArmDb As Object
Private ms_UID As String
Private ms_LanguageCode As String
Private ms_ConnectString As String
Private mb_use_framework_connection As Boolean

Private ma_KeyList As Variant
Private ma_DataChoices As Variant

Public Property Let DataType(aet_DataType As DataTypeEnum)
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc True, "ReportForm:DataType_Let"
    #End If
    CapMouseOff

    Select Case aet_DataType
        Case project
            ReportProject
        Case Customer
            ReportCustomer
    End Select
    
Trace_End:
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc False, "ReportForm:DataType_Let"
    #End If
    CapMouseOn
End Property

Public Property Set ArmDb(ByRef ao_local_connection As Object)
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc True, "ReportForm:ArmDb_Set"
    #End If
    CapMouseOff
    
    If Not (ao_local_connection Is Nothing) Then
        Set mo_ArmDb = ao_local_connection
        mb_use_framework_connection = True
        Set ArmPrint.ArmDb = mo_ArmDb
    End If
Trace_End:
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc False, "ReportForm:ArmDb_Set"
    #End If
    CapMouseOn
End Property

Property Let ConnectString(as_ConnectString As String)
    
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc True, "ReportForm:ConnectString_Let", "as_ConnectString=" & as_ConnectString
    #End If
    CapMouseOff
    
    ms_UID = ConnectionStringValidation(as_ConnectString)
    If ms_UID = "" Then GoTo Trace_End
    
    ms_ConnectString = as_ConnectString
    ArmPrint.ConnectString = ms_ConnectString
        
Trace_End:
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc False, "ReportForm:ConnectString_Let"
    #End If
    CapMouseOn
End Property

Property Let Language(ALng As String)
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc True, "ReportForm:Language_Let", "ALng=" & ALng
    #End If
    ms_LanguageCode = ALng
    
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc False, "ReportForm:Language_Let"
    #End If
End Property

Public Property Let Key(aa_KeyList As Variant)
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc True, "ReportForm:Key_Let", "aa_KeyList=", aa_KeyList
    #End If

    ma_KeyList = aa_KeyList

    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc False, "ReportForm:Key_Let"
    #End If
End Property


Public Property Let DataChoice(aa_DataChoice As Variant)
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc True, "ReportForm:Key_Let", "aa_KeyList=", aa_DataChoice
    #End If

    ma_DataChoices = aa_DataChoice
    
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc False, "ReportForm:Key_Let"
    #End If
End Property


Public Sub Load_A_COM()

    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc True, "ReportForm:Load_A_Com"
    #End If
    CapMouseOff
    
    ArmPrint.Load_A_COM
    ArmPrint.Charset = GetCharSetFromCodePage(GetCodePageFromLanguage(mo_ArmDb, ms_LanguageCode))
    
Trace_End:
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc False, "ReportForm:Load_A_Com"
    #End If
    CapMouseOn
End Sub

Public Sub Unload_A_COM()
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc True, "ReportForm:Unload_A_Com"
    #End If
    CapMouseOff

    ArmPrint.Unload_A_COM
    
Trace_End:
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc False, "ReportForm:Unload_A_Com"
    #End If
    CapMouseOn
End Sub

Public Sub ReportProject()
Dim lv_Reports As Variant

    'Set ArmPrint.ArmTrace = mo_Trace
    'change this path to our xml file
    ArmPrint.XML_Path = App.Path & "\Capture.xml"
    'we can insert five keys in one go
    ArmPrint.InsertTempKeyCount = 10
    'here is stored procedure to insert temporary keys
    ArmPrint.CreateTempTableRequest = "CREATE TABLE [#Cap_ExcelExport] ([Code] [int] Identity(1,1),[User_ID] [varchar] (30) NULL ,[CapKey1] [varchar] (20) NULL ,    [CapKey2] [varchar] (20) NULL) ON [PRIMARY]"
    ArmPrint.DropTempTableRequest = "DROP TABLE [#Cap_ExcelExport]"
    ArmPrint.InsertTempKeyRequest = "exec Cap_ExcelExport_ins '$User_ID$','$0$','$1$','$2$','$3$','$4$', '$5$', '$6$', '$7$', '$8$', '$9$'"
    'set special placeholders and its values (values can be translated)
    ArmPrint.Placeholders = Array("User_ID" & ms_UID, "PageDate" & Date, "LangCode" & ms_LanguageCode, "PageText#lbl_Page")
    'set request to retrieve report constants
    Call ArmPrint.SetConstantRequest("exec screen_csts 'Cap_ProjectDetailPrint','$LangCode$'", "Field_Name", "Local_Text")
    'request for get sales project main data (mainly for header) - for each record of this request = one new page in report
    ArmPrint.Request = "EXEC Cap_ExcelExportSalesProject_lst '$User_ID$', '$LangCode$'"
    
    'special field - SA_Desc and request to get its value (ca return more than one row, result will be concatenated)
    'it can be an array of special fields and its values
    'ArmPrint.SpecialFields = "SA_DescSELECT SA_Desc FROM Sales_Project SP INNER JOIN Cap_StratAccount SA ON (SP.SA_Code=SA.SA_Code AND SA.Language_Code='E') WHERE SP.SP_CapKey='$SP_CapKey$' AND SP.SP_SAFlag='X'"
    'here will be passed multi key from ArmGrid, property should be compatible
    ArmPrint.MultiKey = ma_KeyList
    
    'text which will be displayed in footer of each page
    ArmPrint.FooterText = "$User_ID$ $PageDate$ $PageText$ $CurrentPage()$/$TotalPages()$"
    'number of reports in report definition
    
    ArmPrint.ReportCount = 5
    ReDim lv_Reports(ArmPrint.ReportCount - 1)
    
    lv_Reports(0) = Array("Project", "#Title", "HEADER", "", True)
    
    lv_Reports(1) = Array("ProjectContacts", "#lbl_ContactSection", "TABLE", _
        "EXEC Cap_ExcelExport_Contact_Sel '$SP_CapKey$', '$LangCode$'", ma_DataChoices(0))
    
    lv_Reports(2) = Array("ProjectCompany", "#lbl_CustomerSection", "TABLE", _
        "EXEC Cap_ExcelExport_Company_Sel '$SP_CapKey$', '$LangCode$'", ma_DataChoices(3))
    
    lv_Reports(3) = Array("ProjectActions", "#lbl_ActionSection", "TABLE", _
        "EXEC Cap_ExcelExport_Action_Sel '$SP_CapKey$', '$LangCode$'", ma_DataChoices(2))
    
    lv_Reports(4) = Array("ProjectSpec", "#lbl_SpecSection", "TABLE", _
        "EXEC Cap_ExcelExport_Product_Sel '$SP_CapKey$', '$LangCode$'", ma_DataChoices(1))
    
    'this is our report definition
    Call ArmPrint.SetReportList(lv_Reports)
    Call ArmPrint.Execute

Trace_End:
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc False, "ReportForm:ReportProject"
    #End If
    CapMouseOn
    Exit Sub
    
Trace_Err:
    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, "ReportForm:ReportProject"
    CapMouseOn
End Sub

Public Sub ReportCustomer()
Dim lv_Reports As Variant

    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc True, "ReportForm:ReportCustomer"
    #End If
    CapMouseOff
  
    'Set ArmPrint.ArmTrace = mo_Trace
    'change this path to our xml file
    ArmPrint.XML_Path = App.Path & "\Capture.xml"
    'we can insert five keys in one go
    ArmPrint.InsertTempKeyCount = 10
    'here is stored procedure to insert temporary keys
    ArmPrint.CreateTempTableRequest = "CREATE TABLE [#Cap_ExcelExport] ([Code] [int] Identity(1,1),[User_ID] [varchar] (30) NULL ,[CapKey1] [varchar] (20) NULL ,    [CapKey2] [varchar] (20) NULL) ON [PRIMARY]"
    ArmPrint.DropTempTableRequest = "DROP TABLE [#Cap_ExcelExport]"
    ArmPrint.InsertTempKeyRequest = "exec Cap_ExcelExport_ins '$User_ID$','$0$','$1$','$2$','$3$','$4$', '$5$', '$6$', '$7$', '$8$', '$9$'"
    'set special placeholders and its values (values can be translated)
    ArmPrint.Placeholders = Array("User_ID" & ms_UID, "PageDate" & Date, "LangCode" & ms_LanguageCode, "PageText#lbl_Page")
    'set request to retrieve report constants
    Call ArmPrint.SetConstantRequest("exec screen_csts 'Cap_CustomerDetailPrint','$LangCode$'", "Field_Name", "Local_Text")
    'request for get sales project main data (mainly for header) - for each record of this request = one new page in report
    ArmPrint.Request = "EXEC Cap_ExcelExport_Claim_Customer_lst '$User_ID$', '$LangCode$'"
    
    'special field - SA_Desc and request to get its value (ca return more than one row, result will be concatenated)
    'it can be an array of special fields and its values
    ArmPrint.SpecialFields = "SA_DescSELECT SA_Desc FROM Cap_StratAccount SA INNER JOIN Cap_CustomerSA CCUSA ON CCUSA.SA_Code = SA.SA_Code AND CCUSA.CCU_Capkey = '$CCU_CapKey$' WHERE SA.Language_Code = '$LangCode$'"

    'here will be passed multi key from ArmGrid, property should be compatible
    ArmPrint.MultiKey = ma_KeyList
    
    'text which will be displayed in footer of each page
    ArmPrint.FooterText = "$User_ID$ $PageDate$ $PageText$ $CurrentPage()$/$TotalPages()$"
    'number of reports in report definition
    
    ArmPrint.ReportCount = 4
    ReDim lv_Reports(ArmPrint.ReportCount - 1)
    
    lv_Reports(0) = Array("Customer", "#Title", "HEADER", "", True)
    
    lv_Reports(1) = Array("CustomerContacts", "#lbl_ContactSection", "TABLE", _
        "EXEC Cap_ExcelExport_Contact_Sel2 '$CCU_CapKey$', '$LangCode$'", ma_DataChoices(0))
    
    lv_Reports(2) = Array("CustomerActions", "#lbl_ActionSection", "TABLE", _
       "EXEC Cap_ExcelExport_Action_Sel2 '$CCU_CapKey$', '$LangCode$'", ma_DataChoices(1))
    
    
    lv_Reports(3) = Array("CustomerProjects", "#lbl_ProjectSection", "TABLE", _
       "EXEC Cap_ExcelExport_Project_Sel '$CCU_CapKey$', '$LangCode$'", ma_DataChoices(2))
   
    'this is our report definition
    Call ArmPrint.SetReportList(lv_Reports)
    Call ArmPrint.Execute

Trace_End:
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc False, "ReportForm:ReportCustomer"
    #End If
    CapMouseOn
    Exit Sub
    
Trace_Err:
    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, "ReportForm:ReportCustomer"
    CapMouseOn
End Sub

Private Sub Form_Resize()
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc True, "ReportForm:Form_Resize"
    #End If
    CapMouseOff
    
    ArmPrint.left = 0
    ArmPrint.top = 0
    ArmPrint.Width = Me.ScaleWidth
    ArmPrint.Height = Me.ScaleHeight

Trace_End:
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc False, "ReportForm:Form_Resize"
    #End If
    CapMouseOn
End Sub

